<?php

/**
 * This is the model class for table "BiuroFirmy".
 *
 * The followings are the available columns in table 'BiuroFirmy':
 * @property double $idFirmy
 * @property double $idBiura
 * @property string $czasWynajmu
 * @property string $czasRezygnacji
 * @property double $id
 *
 * @property Biuro $biuro
 * @property Firma $firma
 */
class BiuroFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BiuroFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'BiuroFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idFirmy, idBiura, id', 'numerical'),
			array('idFirmy, idBiura, id, czasWynajmu, czasRezygnacji', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'biuro' => array(self::BELONGS_TO, 'Biuro', 'idBiura'),
			'firma' => array(self::BELONGS_TO, 'Firma', 'idFirmy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idFirmy'=>Yii::t('BiuroFirmy', 'idFirmy'),
			'idBiura'=>Yii::t('BiuroFirmy', 'idBiura'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idFirmy', $this->idFirmy);
		$criteria->compare('idBiura', $this->idBiura);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}